/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import processing.core.PApplet;
import processing.core.PSound;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PSound2
extends PSound {
    Clip clip;
    FloatControl gainControl;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;
    static /* synthetic */ Class class$processing$core$PSound;

    public void play() {
        this.clip.start();
    }

    public void loop() {
        this.clip.loop(-1);
    }

    public void noLoop() {
        this.clip.loop(0);
    }

    public void pause() {
        this.clip.stop();
    }

    public void stop() {
        this.clip.stop();
        this.clip.setFramePosition(0);
    }

    public void dispose() {
        this.stop();
        this.clip = null;
    }

    public float time() {
        return (float)((double)this.clip.getMicrosecondPosition() / 1000000.0);
    }

    public float duration() {
        return (float)this.clip.getBufferSize() / ((float)this.clip.getFormat().getFrameSize() * this.clip.getFormat().getFrameRate());
    }

    public void volume(float f) {
        float f2 = (float)(Math.log(f) / Math.log(10.0) * 20.0);
        this.gainControl.setValue(f2);
    }

    protected void error(String string, Exception exception) {
        this.parent.die("Error inside PSound2." + string + "()", exception);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PSound2(PApplet pApplet, InputStream inputStream) {
        this.parent = pApplet;
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            AudioFormat audioFormat = audioInputStream.getFormat();
            if (audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() * 2, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), true);
                audioInputStream = AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
            }
            int n = (int)audioInputStream.getFrameLength();
            int n2 = audioFormat.getFrameSize();
            Class clazz = class$javax$sound$sampled$Clip;
            if (clazz == null) {
                clazz = class$javax$sound$sampled$Clip = PSound2.class("[Ljavax.sound.sampled.Clip;", false);
            }
            DataLine.Info info = new DataLine.Info(clazz, audioInputStream.getFormat(), n * n2);
            this.clip = (Clip)AudioSystem.getLine(info);
            this.gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
            this.clip.open(audioInputStream);
            this.parent.registerDispose(this);
            try {
                Class<?> clazz2 = this.parent.getClass();
                Class[] classArray = new Class[1];
                Class clazz3 = class$processing$core$PSound;
                if (clazz3 == null) {
                    clazz3 = class$processing$core$PSound = PSound2.class("[Lprocessing.core.PSound;", false);
                }
                classArray[0] = clazz3;
                this.soundEventMethod = clazz2.getMethod("soundEvent", classArray);
                this.clip.addLineListener(new LineListener(){

                    public final void update(LineEvent lineEvent) {
                        if (lineEvent.getType() == LineEvent.Type.STOP) {
                            try {
                                PSound2.this.soundEventMethod.invoke((Object)PSound2.this.parent, PSound2.this);
                            }
                            catch (Exception exception) {
                                System.err.println("error, disabling soundEvent()");
                                exception.printStackTrace();
                                PSound2.this.soundEventMethod = null;
                            }
                        }
                    }
                });
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            this.error("<init>", exception);
        }
    }
}

