/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import processing.core.PConstants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PImage
implements PConstants,
Cloneable {
    static final int PRECISIONB = 15;
    static final int PRECISIONF = 32768;
    static final int PREC_MAXVAL = Short.MAX_VALUE;
    static final int PREC_ALPHA_SHIFT = 9;
    static final int PREC_RED_SHIFT = 1;
    static byte[] tiff_header;
    public int format;
    public int[] pixels;
    public int width;
    public int height;
    public int imageMode;
    public boolean smooth;
    public Object cache;
    public boolean modified;
    public int mx1;
    public int my1;
    public int mx2;
    public int my2;
    private int fracU;
    private int ifU;
    private int fracV;
    private int ifV;
    private int u1;
    private int u2;
    private int v1;
    private int v2;
    private int sX;
    private int sY;
    private int iw;
    private int iw1;
    private int ih1;
    private int ul;
    private int ll;
    private int ur;
    private int lr;
    private int cUL;
    private int cLL;
    private int cUR;
    private int cLR;
    private int srcXOffset;
    private int srcYOffset;
    private int r;
    private int g;
    private int b;
    private int a;
    private int[] srcBuffer;
    int blurRadius;
    int blurKernelSize;
    int[] blurKernel;
    int[][] blurMult;

    public void init(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.pixels = new int[n * n2];
        this.format = n3;
        this.cache = null;
    }

    public void imageMode(int n) {
        if (n != 0 && n != 1) {
            throw new RuntimeException("imageMode() only works with CORNER or CORNERS");
        }
        this.imageMode = n;
    }

    public void smooth() {
        this.smooth = true;
    }

    public void noSmooth() {
        this.smooth = false;
    }

    public void loadPixels() {
    }

    public void updatePixels() {
        this.updatePixels(0, 0, this.width, this.height);
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        if (this.imageMode == 0) {
            n3 += n;
            n4 += n2;
        }
        if (!this.modified) {
            this.mx1 = n;
            this.mx2 = n3;
            this.my1 = n2;
            this.my2 = n4;
            this.modified = true;
        } else {
            if (n < this.mx1) {
                this.mx1 = n;
            }
            if (n > this.mx2) {
                this.mx2 = n;
            }
            if (n2 < this.my1) {
                this.my1 = n2;
            }
            if (n2 > this.my2) {
                this.my2 = n2;
            }
            if (n3 < this.mx1) {
                this.mx1 = n3;
            }
            if (n3 > this.mx2) {
                this.mx2 = n3;
            }
            if (n4 < this.my1) {
                this.my1 = n4;
            }
            if (n4 > this.my2) {
                this.my2 = n4;
            }
        }
    }

    public int get(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 0;
        }
        switch (this.format) {
            case 1: {
                return this.pixels[n2 * this.width + n] | 0xFF000000;
            }
            case 2: {
                return this.pixels[n2 * this.width + n];
            }
            case 4: {
                return this.pixels[n2 * this.width + n] << 24 | 0xFFFFFF;
            }
        }
        return 0;
    }

    public PImage get(int n, int n2, int n3, int n4) {
        if (this.imageMode == 1) {
            n3 -= n;
            n4 -= n;
        }
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 = this.width - n;
        }
        if (n2 + n4 > this.height) {
            n4 = this.height - n2;
        }
        PImage pImage = new PImage(new int[n3 * n4], n3, n4, this.format);
        int n5 = n2 * this.width + n;
        int n6 = 0;
        int n7 = n2;
        while (n7 < n2 + n4) {
            System.arraycopy(this.pixels, n5, pImage.pixels, n6, n3);
            n5 += this.width;
            n6 += n3;
            ++n7;
        }
        return pImage;
    }

    public PImage get() {
        try {
            return (PImage)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void set(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        this.pixels[n2 * this.width + n] = n3;
    }

    public void set(int n, int n2, PImage pImage) {
        int n3 = 0;
        int n4 = 0;
        int n5 = pImage.width;
        int n6 = pImage.height;
        if (n < 0) {
            n3 -= n;
            n5 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 -= n2;
            n6 += n2;
            n2 = 0;
        }
        if (n + n5 > this.width) {
            n5 = this.width - n;
        }
        if (n2 + n6 > this.height) {
            n6 = this.height - n2;
        }
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        this.setImpl(n, n2, n3, n4, n5, n6, pImage);
    }

    protected void setImpl(int n, int n2, int n3, int n4, int n5, int n6, PImage pImage) {
        int n7 = n4 * pImage.width + n3;
        int n8 = n2 * this.width + n;
        int n9 = n4;
        while (n9 < n4 + n6) {
            System.arraycopy(pImage.pixels, n7, this.pixels, n8, n5);
            n7 += pImage.width;
            n8 += this.width;
            ++n9;
        }
    }

    public void mask(int[] nArray) {
        if (nArray.length != this.pixels.length) {
            throw new RuntimeException("The PImage used with mask() must be the same size as the applet.");
        }
        int n = 0;
        while (n < this.pixels.length) {
            this.pixels[n] = (nArray[n] & 0xFF) << 24 | this.pixels[n] & 0xFFFFFF;
            ++n;
        }
        this.format = 2;
    }

    public void mask(PImage pImage) {
        this.mask(pImage.pixels);
    }

    public void filter(int n) {
        switch (n) {
            case 11: {
                this.filter(11, 1.0f);
                break;
            }
            case 12: {
                int n2 = 0;
                while (n2 < this.pixels.length) {
                    int n3 = this.pixels[n2];
                    int n4 = 77 * (n3 >> 16 & 0xFF) + 151 * (n3 >> 8 & 0xFF) + 28 * (n3 & 0xFF) >> 8;
                    this.pixels[n2] = n3 & 0xFF000000 | n4 << 16 | n4 << 8 | n4;
                    ++n2;
                }
                break;
            }
            case 13: {
                int n5 = 0;
                while (n5 < this.pixels.length) {
                    int n6 = n5++;
                    this.pixels[n6] = this.pixels[n6] ^ 0xFFFFFF;
                }
                break;
            }
            case 15: {
                throw new RuntimeException("Use filter(POSTERIZE, int levels) instead of filter(POSTERIZE)");
            }
            case 1: {
                int n7 = 0;
                while (n7 < this.pixels.length) {
                    int n8 = n7++;
                    this.pixels[n8] = this.pixels[n8] | 0xFF000000;
                }
                this.format = 1;
                break;
            }
            case 16: {
                this.filter(16, 0.5f);
                break;
            }
        }
        this.updatePixels();
    }

    public void filter(int n, float f) {
        switch (n) {
            case 11: {
                this.blur(f);
                break;
            }
            case 12: {
                throw new RuntimeException("Use filter(GRAY) instead of filter(GRAY, param)");
            }
            case 13: {
                throw new RuntimeException("Use filter(INVERT) instead of filter(INVERT, param)");
            }
            case 14: {
                throw new RuntimeException("Use filter(OPAQUE) instead of filter(OPAQUE, param)");
            }
            case 15: {
                int n2 = (int)f;
                if (n2 < 2 || n2 > 255) {
                    throw new RuntimeException("Levels must be between 2 and 255 for filter(POSTERIZE, levels)");
                }
                int n3 = 256 / n2;
                int n4 = n2 - 1;
                int n5 = 0;
                while (n5 < this.pixels.length) {
                    int n6 = (this.pixels[n5] >> 16 & 0xFF) / n3;
                    int n7 = (this.pixels[n5] >> 8 & 0xFF) / n3;
                    int n8 = (this.pixels[n5] & 0xFF) / n3;
                    n6 = n6 * 255 / n4 & 0xFF;
                    n7 = n7 * 255 / n4 & 0xFF;
                    n8 = n8 * 255 / n4 & 0xFF;
                    this.pixels[n5] = 0xFF000000 & this.pixels[n5] | n6 << 16 | n7 << 8 | n8;
                    ++n5;
                }
                break;
            }
            case 16: {
                int n9 = (int)(f * 255.0f);
                int n10 = 0;
                while (n10 < this.pixels.length) {
                    int n11 = Math.max((this.pixels[n10] & 0xFF0000) >> 16, Math.max((this.pixels[n10] & 0xFF00) >> 8, this.pixels[n10] & 0xFF));
                    this.pixels[n10] = this.pixels[n10] & 0xFF000000 | (n11 < n9 ? 0 : 0xFFFFFF);
                    ++n10;
                }
                break;
            }
        }
        this.updatePixels();
    }

    protected void blur(float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = (int)(f * 3.5f);
        int n10 = 1;
        if (n9 >= 1) {
            n10 = n9 < 248 ? n9 : 248;
        }
        if (this.blurRadius != (n9 = n10)) {
            this.blurRadius = n9;
            this.blurKernelSize = 1 + n9 * 2;
            this.blurKernel = new int[this.blurKernelSize];
            this.blurMult = new int[this.blurKernelSize][256];
            n8 = 0;
            n7 = 1;
            while (n7 < n9) {
                n6 = n9 - n7;
                this.blurKernel[n9 + n7] = this.blurKernel[n6] = n6 * n6;
                n8 += this.blurKernel[n6] + this.blurKernel[n6];
                n5 = 0;
                while (n5 < 256) {
                    int n11 = this.blurKernel[n6] * n5;
                    this.blurMult[n6][n5] = n11;
                    this.blurMult[n9 + n7][n5] = n11;
                    ++n5;
                }
                ++n7;
            }
            this.blurKernel[n9] = n9 * n9;
            n8 += this.blurKernel[n9];
            n7 = 0;
            while (n7 < 256) {
                this.blurMult[n9][n7] = this.blurKernel[n9] * n7;
                ++n7;
            }
        }
        int n12 = this.width * this.height;
        int[] nArray = new int[n12];
        int[] nArray2 = new int[n12];
        int[] nArray3 = new int[n12];
        int n13 = 0;
        while (n13 < n12) {
            n4 = this.pixels[n13];
            nArray[n13] = (n4 & 0xFF0000) >> 16;
            nArray2[n13] = (n4 & 0xFF00) >> 8;
            nArray3[n13] = n4 & 0xFF;
            ++n13;
        }
        int[] nArray4 = new int[n12];
        int[] nArray5 = new int[n12];
        int[] nArray6 = new int[n12];
        int n14 = 0;
        int n15 = 0;
        int n16 = this.width;
        int n17 = this.height;
        int n18 = n15 * this.width;
        int n19 = n15;
        while (n19 < n17) {
            n3 = n14;
            while (n3 < n16) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = n3 - this.blurRadius;
                n2 = 0;
                while (n2 < this.blurKernelSize) {
                    n = n4 + n2;
                    if (n >= n14 && n < n16) {
                        n7 += this.blurMult[n2][nArray[n += n18]];
                        n6 += this.blurMult[n2][nArray2[n]];
                        n5 += this.blurMult[n2][nArray3[n]];
                        n8 += this.blurKernel[n2];
                    }
                    ++n2;
                }
                n4 = n18 + n3;
                nArray4[n4] = n7 / n8;
                nArray5[n4] = n6 / n8;
                nArray6[n4] = n5 / n8;
                ++n3;
            }
            n18 += this.width;
            ++n19;
        }
        n18 = n15 * this.width;
        n19 = n15;
        while (n19 < n17) {
            int n20 = n19 - this.blurRadius;
            int n21 = n20 * this.width;
            n3 = n14;
            while (n3 < n16) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = n20;
                n = n3 + n21;
                n2 = 0;
                while (n2 < this.blurKernelSize) {
                    if (n4 < n17 && n4 >= n15) {
                        n7 += this.blurMult[n2][nArray4[n]];
                        n6 += this.blurMult[n2][nArray5[n]];
                        n5 += this.blurMult[n2][nArray6[n]];
                        n8 += this.blurKernel[n2];
                    }
                    ++n4;
                    n += this.width;
                    ++n2;
                }
                this.pixels[n3 + n18] = 0xFF000000 | n7 / n8 << 16 | n6 / n8 << 8 | n5 / n8;
                ++n3;
            }
            n18 += this.width;
            ++n19;
        }
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.copy(this, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.imageMode == 0) {
            n3 += n;
            n4 += n2;
            n7 += n5;
            n8 += n6;
        }
        if (pImage == this && this.intersect(n, n2, n3, n4, n5, n6, n7, n8)) {
            this.blit_resize(this.get(n, n2, n3 - n, n4 - n2), 0, 0, n3 - n - 1, n4 - n2 - 1, this.pixels, this.width, this.height, n5, n6, n7, n8, 0);
        } else {
            this.blit_resize(pImage, n, n2, n3, n4, this.pixels, this.width, this.height, n5, n6, n7, n8, 0);
        }
    }

    public static int blend(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return PImage.blend_multiply(n, n2);
            }
            case 2: {
                return PImage.blend_add_pin(n, n2);
            }
            case 4: {
                return PImage.blend_sub_pin(n, n2);
            }
            case 8: {
                return PImage.blend_lightest(n, n2);
            }
            case 16: {
                return PImage.blend_darkest(n, n2);
            }
            case 0: {
                return n2;
            }
        }
        return 0;
    }

    public void blend(int n, int n2, int n3, int n4, int n5) {
        if (n3 >= 0 && n3 < this.width && n >= 0 && n < this.width && n4 >= 0 && n4 < this.height && n2 >= 0 && n2 < this.height) {
            this.pixels[n4 * this.width + n3] = PImage.blend(this.pixels[n4 * this.width + n3], this.pixels[n2 * this.width + n], n5);
        }
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5) {
        if (n3 >= 0 && n3 < this.width && n >= 0 && n < pImage.width && n4 >= 0 && n4 < this.height && n2 >= 0 && n2 < pImage.height) {
            this.pixels[n4 * this.width + n3] = PImage.blend(this.pixels[n4 * this.width + n3], pImage.pixels[n2 * pImage.width + n], n5);
        }
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.blend(this, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.imageMode == 0) {
            n3 += n;
            n4 += n2;
            n7 += n5;
            n8 += n6;
        }
        if (pImage == this && this.intersect(n, n2, n3, n4, n5, n6, n7, n8)) {
            this.blit_resize(this.get(n, n2, n3 - n, n4 - n2), 0, 0, n3 - n - 1, n4 - n2 - 1, this.pixels, this.width, this.height, n5, n6, n7, n8, n9);
        } else {
            this.blit_resize(pImage, n, n2, n3, n4, this.pixels, this.width, this.height, n5, n6, n7, n8, n9);
        }
    }

    protected boolean intersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10 = n3 - n + 1;
        int n11 = n4 - n2 + 1;
        int n12 = n7 - n5 + 1;
        int n13 = n8 - n6 + 1;
        if (n5 < n) {
            if ((n12 += n5 - n) > n10) {
                n12 = n10;
            }
        } else {
            n9 = n10 + n - n5;
            if (n12 > n9) {
                n12 = n9;
            }
        }
        if (n6 < n2) {
            if ((n13 += n6 - n2) > n11) {
                n13 = n11;
            }
        } else {
            n9 = n11 + n2 - n6;
            if (n13 > n9) {
                n13 = n9;
            }
        }
        boolean bl = false;
        if (n12 <= 0 || n13 <= 0) {
            bl = true;
        }
        return bl ^ true;
    }

    public Object clone() throws CloneNotSupportedException {
        PImage pImage = (PImage)super.clone();
        pImage.pixels = new int[this.width * this.height];
        System.arraycopy(this.pixels, 0, pImage.pixels, 0, this.pixels.length);
        return pImage;
    }

    private final void blit_resize(PImage pImage, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        block49: {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            block48: {
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n3 >= pImage.width) {
                    n3 = pImage.width - 1;
                }
                if (n4 >= pImage.width) {
                    n4 = pImage.height - 1;
                }
                int n17 = n3 - n;
                int n18 = n4 - n2;
                n16 = n9 - n7;
                n15 = n10 - n8;
                if (!this.smooth) {
                    ++n17;
                    ++n18;
                }
                if (n16 <= 0 || n15 <= 0 || n17 <= 0 || n18 <= 0 || n7 >= n5 || n8 >= n6 || n >= pImage.width || n2 >= pImage.height) {
                    return;
                }
                n14 = (int)((float)n17 / (float)n16 * 32768.0f);
                n13 = (int)((float)n18 / (float)n15 * 32768.0f);
                this.srcXOffset = n7 < 0 ? -n7 * n14 : n * 32768;
                int n19 = this.srcYOffset = n8 < 0 ? -n8 * n13 : n2 * 32768;
                if (n7 < 0) {
                    n16 += n7;
                    n7 = 0;
                }
                if (n8 < 0) {
                    n15 += n8;
                    n8 = 0;
                }
                n16 = PImage.low(n16, n5 - n7);
                n15 = PImage.low(n15, n6 - n8);
                n12 = n8 * n5 + n7;
                this.srcBuffer = pImage.pixels;
                if (!this.smooth) break block48;
                this.iw = pImage.width;
                this.iw1 = pImage.width - 1;
                this.ih1 = pImage.height - 1;
                switch (n11) {
                    case 1: {
                        int n20 = 0;
                        while (n20 < n15) {
                            this.filter_new_scanline();
                            int n21 = 0;
                            while (n21 < n16) {
                                nArray[n12 + n21] = PImage.blend_multiply(nArray[n12 + n21], this.filter_bilinear());
                                this.sX += n14;
                                ++n21;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n20;
                        }
                        break block49;
                    }
                    case 2: {
                        int n22 = 0;
                        while (n22 < n15) {
                            this.filter_new_scanline();
                            int n23 = 0;
                            while (n23 < n16) {
                                nArray[n12 + n23] = PImage.blend_add_pin(nArray[n12 + n23], this.filter_bilinear());
                                this.sX += n14;
                                ++n23;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n22;
                        }
                        break block49;
                    }
                    case 4: {
                        int n24 = 0;
                        while (n24 < n15) {
                            this.filter_new_scanline();
                            int n25 = 0;
                            while (n25 < n16) {
                                nArray[n12 + n25] = PImage.blend_sub_pin(nArray[n12 + n25], this.filter_bilinear());
                                this.sX += n14;
                                ++n25;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n24;
                        }
                        break block49;
                    }
                    case 8: {
                        int n26 = 0;
                        while (n26 < n15) {
                            this.filter_new_scanline();
                            int n27 = 0;
                            while (n27 < n16) {
                                nArray[n12 + n27] = PImage.blend_lightest(nArray[n12 + n27], this.filter_bilinear());
                                this.sX += n14;
                                ++n27;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n26;
                        }
                        break block49;
                    }
                    case 16: {
                        int n28 = 0;
                        while (n28 < n15) {
                            this.filter_new_scanline();
                            int n29 = 0;
                            while (n29 < n16) {
                                nArray[n12 + n29] = PImage.blend_darkest(nArray[n12 + n29], this.filter_bilinear());
                                this.sX += n14;
                                ++n29;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n28;
                        }
                        break block49;
                    }
                    case 0: {
                        int n30 = 0;
                        while (n30 < n15) {
                            this.filter_new_scanline();
                            int n31 = 0;
                            while (n31 < n16) {
                                nArray[n12 + n31] = this.filter_bilinear();
                                this.sX += n14;
                                ++n31;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n30;
                        }
                        break block49;
                    }
                }
                break block49;
            }
            switch (n11) {
                case 1: {
                    int n32 = 0;
                    while (n32 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n33 = 0;
                        while (n33 < n16) {
                            nArray[n12 + n33] = PImage.blend_multiply(nArray[n12 + n33], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n33;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n32;
                    }
                    break;
                }
                case 2: {
                    int n34 = 0;
                    while (n34 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n35 = 0;
                        while (n35 < n16) {
                            nArray[n12 + n35] = PImage.blend_add_pin(nArray[n12 + n35], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n35;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n34;
                    }
                    break;
                }
                case 4: {
                    int n36 = 0;
                    while (n36 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n37 = 0;
                        while (n37 < n16) {
                            nArray[n12 + n37] = PImage.blend_sub_pin(nArray[n12 + n37], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n37;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n36;
                    }
                    break;
                }
                case 8: {
                    int n38 = 0;
                    while (n38 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n39 = 0;
                        while (n39 < n16) {
                            nArray[n12 + n39] = PImage.blend_lightest(nArray[n12 + n39], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n39;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n38;
                    }
                    break;
                }
                case 16: {
                    int n40 = 0;
                    while (n40 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n41 = 0;
                        while (n41 < n16) {
                            nArray[n12 + n41] = PImage.blend_darkest(nArray[n12 + n41], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n41;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n40;
                    }
                    break;
                }
                case 0: {
                    int n42 = 0;
                    while (n42 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n43 = 0;
                        while (n43 < n16) {
                            nArray[n12 + n43] = this.srcBuffer[this.sY + (this.sX >> 15)];
                            this.sX += n14;
                            ++n43;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n42;
                    }
                    break;
                }
            }
        }
    }

    private final void filter_new_scanline() {
        this.sX = this.srcXOffset;
        this.fracV = this.srcYOffset & Short.MAX_VALUE;
        this.ifV = Short.MAX_VALUE - this.fracV;
        this.v1 = (this.srcYOffset >> 15) * this.iw;
        this.v2 = PImage.low((this.srcYOffset >> 15) + 1, this.ih1) * this.iw;
    }

    private final int filter_bilinear() {
        this.fracU = this.sX & Short.MAX_VALUE;
        this.ifU = Short.MAX_VALUE - this.fracU;
        this.ul = this.ifU * this.ifV >> 15;
        this.ll = this.ifU * this.fracV >> 15;
        this.ur = this.fracU * this.ifV >> 15;
        this.lr = this.fracU * this.fracV >> 15;
        this.u1 = this.sX >> 15;
        this.u2 = PImage.low(this.u1 + 1, this.iw1);
        this.cUL = this.srcBuffer[this.v1 + this.u1];
        this.cUR = this.srcBuffer[this.v1 + this.u2];
        this.cLL = this.srcBuffer[this.v2 + this.u1];
        this.cLR = this.srcBuffer[this.v2 + this.u2];
        this.r = this.ul * ((this.cUL & 0xFF0000) >> 16) + this.ll * ((this.cLL & 0xFF0000) >> 16) + this.ur * ((this.cUR & 0xFF0000) >> 16) + this.lr * ((this.cLR & 0xFF0000) >> 16) << 1 & 0xFF0000;
        this.g = this.ul * (this.cUL & 0xFF00) + this.ll * (this.cLL & 0xFF00) + this.ur * (this.cUR & 0xFF00) + this.lr * (this.cLR & 0xFF00) >>> 15 & 0xFF00;
        this.b = this.ul * (this.cUL & 0xFF) + this.ll * (this.cLL & 0xFF) + this.ur * (this.cUR & 0xFF) + this.lr * (this.cLR & 0xFF) >>> 15;
        this.a = this.ul * ((this.cUL & 0xFF000000) >>> 24) + this.ll * ((this.cLL & 0xFF000000) >>> 24) + this.ur * ((this.cUR & 0xFF000000) >>> 24) + this.lr * ((this.cLR & 0xFF000000) >>> 24) << 9 & 0xFF000000;
        return this.a | this.r | this.g | this.b;
    }

    private static final int low(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private static final int high(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static final float frac(float f) {
        return f - (float)((int)f);
    }

    private static final int mix(int n, int n2, int n3) {
        return n + ((n2 - n) * n3 >> 8);
    }

    private static final int blend_multiply(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.mix(n & 0xFF0000, n2 & 0xFF0000, n3) & 0xFF0000 | PImage.mix(n & 0xFF00, n2 & 0xFF00, n3) & 0xFF00 | PImage.mix(n & 0xFF, n2 & 0xFF, n3);
    }

    private static final int blend_add_pin(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.low((n & 0xFF0000) + ((n2 & 0xFF0000) >> 8) * n3, 0xFF0000) & 0xFF0000 | PImage.low((n & 0xFF00) + ((n2 & 0xFF00) >> 8) * n3, 65280) & 0xFF00 | PImage.low((n & 0xFF) + ((n2 & 0xFF) * n3 >> 8), 255);
    }

    private static final int blend_sub_pin(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.high((n & 0xFF0000) - ((n2 & 0xFF0000) >> 8) * n3, 65280) & 0xFF0000 | PImage.high((n & 0xFF00) - ((n2 & 0xFF00) >> 8) * n3, 255) & 0xFF00 | PImage.high((n & 0xFF) - ((n2 & 0xFF) * n3 >> 8), 0);
    }

    private static final int blend_lightest(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.high(n & 0xFF0000, ((n2 & 0xFF0000) >> 8) * n3) & 0xFF0000 | PImage.high(n & 0xFF00, ((n2 & 0xFF00) >> 8) * n3) & 0xFF00 | PImage.high(n & 0xFF, (n2 & 0xFF) * n3 >> 8);
    }

    private static final int blend_darkest(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.mix(n & 0xFF0000, PImage.low(n & 0xFF0000, ((n2 & 0xFF0000) >> 8) * n3), n3) & 0xFF0000 | PImage.mix(n & 0xFF00, PImage.low(n & 0xFF00, ((n2 & 0xFF00) >> 8) * n3), n3) & 0xFF00 | PImage.mix(n & 0xFF, PImage.low(n & 0xFF, (n2 & 0xFF) * n3 >> 8), n3);
    }

    public static boolean saveHeaderTIFF(OutputStream outputStream, int n, int n2) {
        try {
            byte[] byArray = new byte[768];
            System.arraycopy(tiff_header, 0, byArray, 0, tiff_header.length);
            byArray[30] = (byte)(n >> 8 & 0xFF);
            byArray[31] = (byte)(n & 0xFF);
            byArray[42] = byArray[102] = (byte)(n2 >> 8 & 0xFF);
            byArray[43] = byArray[103] = (byte)(n2 & 0xFF);
            int n3 = n * n2 * 3;
            byArray[114] = (byte)(n3 >> 24 & 0xFF);
            byArray[115] = (byte)(n3 >> 16 & 0xFF);
            byArray[116] = (byte)(n3 >> 8 & 0xFF);
            byArray[117] = (byte)(n3 & 0xFF);
            outputStream.write(byArray);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean saveTIFF(OutputStream outputStream, int[] nArray, int n, int n2) {
        try {
            if (!PImage.saveHeaderTIFF(outputStream, n, n2)) {
                return false;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                outputStream.write(nArray[n3] >> 16 & 0xFF);
                outputStream.write(nArray[n3] >> 8 & 0xFF);
                outputStream.write(nArray[n3] & 0xFF);
                ++n3;
            }
            outputStream.flush();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean saveHeaderTGA(OutputStream outputStream, int n, int n2) {
        try {
            byte[] byArray = new byte[18];
            byArray[2] = 2;
            byArray[12] = (byte)(n & 0xFF);
            byArray[13] = (byte)(n >> 8);
            byArray[14] = (byte)(n2 & 0xFF);
            byArray[15] = (byte)(n2 >> 8);
            byArray[16] = 32;
            byArray[17] = 8;
            outputStream.write(byArray);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean saveTGA(OutputStream outputStream, int[] nArray, int n, int n2) {
        try {
            if (!PImage.saveHeaderTGA(outputStream, n, n2)) {
                return false;
            }
            int n3 = (n2 - 1) * n;
            int n4 = n2 - 1;
            while (n4 >= 0) {
                int n5 = 0;
                while (n5 < n) {
                    int n6 = nArray[n3 + n5];
                    outputStream.write(n6 & 0xFF);
                    outputStream.write(n6 >> 8 & 0xFF);
                    outputStream.write(n6 >> 16 & 0xFF);
                    outputStream.write(n6 >>> 24 & 0xFF);
                    ++n5;
                }
                n3 -= n;
                --n4;
            }
            outputStream.flush();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public void save(String string) {
        try {
            BufferedOutputStream bufferedOutputStream = null;
            if (string.toLowerCase().endsWith(".tga")) {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 32768);
                PImage.saveTGA(bufferedOutputStream, this.pixels, this.width, this.height);
            } else {
                if (!string.toLowerCase().endsWith(".tif") && !string.toLowerCase().endsWith(".tiff")) {
                    string = string + ".tif";
                }
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 32768);
                PImage.saveTIFF(bufferedOutputStream, this.pixels, this.width, this.height);
            }
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private final /* synthetic */ void this() {
        this.imageMode = 0;
        this.smooth = false;
    }

    public PImage() {
        this.this();
        this.format = 1;
        this.cache = null;
    }

    public PImage(int n, int n2) {
        this.this();
        this.init(n, n2, 1);
    }

    public PImage(int[] nArray, int n, int n2, int n3) {
        this.this();
        this.pixels = nArray;
        this.width = n;
        this.height = n2;
        this.format = n3;
        this.cache = null;
    }

    public PImage(Image image) {
        this.this();
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.pixels = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        this.format = 1;
        this.cache = null;
    }

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 77;
        byArray[1] = 77;
        byArray[3] = 42;
        byArray[7] = 8;
        byArray[9] = 9;
        byArray[11] = -2;
        byArray[13] = 4;
        byArray[17] = 1;
        byArray[22] = 1;
        byArray[25] = 3;
        byArray[29] = 1;
        byArray[34] = 1;
        byArray[35] = 1;
        byArray[37] = 3;
        byArray[41] = 1;
        byArray[46] = 1;
        byArray[47] = 2;
        byArray[49] = 3;
        byArray[53] = 3;
        byArray[57] = 122;
        byArray[58] = 1;
        byArray[59] = 6;
        byArray[61] = 3;
        byArray[65] = 1;
        byArray[67] = 2;
        byArray[70] = 1;
        byArray[71] = 17;
        byArray[73] = 4;
        byArray[77] = 1;
        byArray[80] = 3;
        byArray[82] = 1;
        byArray[83] = 21;
        byArray[85] = 3;
        byArray[89] = 1;
        byArray[91] = 3;
        byArray[94] = 1;
        byArray[95] = 22;
        byArray[97] = 3;
        byArray[101] = 1;
        byArray[106] = 1;
        byArray[107] = 23;
        byArray[109] = 4;
        byArray[113] = 1;
        byArray[123] = 8;
        byArray[125] = 8;
        byArray[127] = 8;
        tiff_header = byArray;
    }
}

